/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_rdma_write.c,v 1.11 2005/06/29 00:23:16 eugene Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <unistd.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"
#include "tcp.h"
#include "packet.h"


mx_return_t
mx_rdma_write(mx_endpoint_t endpoint,
              mx_segment_t *segments_list,
              uint32_t segments_count, 
              mx_endpoint_addr_t destination,
              uint32_t window_handle,
              uint32_t offset,
              void *context,
              mx_request_t *request){

  return mx_isend_with_type(endpoint,
                            segments_list,
                            segments_count,
                            destination,
			    0,
                            NULL,
                            request,
                            MX_SR_TYPE_PUT,
                            window_handle,
                            offset,
                            0);

}

#if 0

  struct mx_endpoint *pp;
  struct mx_post *post;
  struct mx_lib_send *send;
  struct mx_lib_address *x;

  /* XXX address_t -> endpoint_t */
  pthread_mutex_lock(&Mx_tx_lock);
  
  pp = (struct mx_endpoint *)endpoint;
  
  /* Build a post descriptor */
  post = mx_new_post(endpoint, MX_POST_TYPE_SEND, context);
  if (post == NULL) {
    pthread_mutex_unlock(&Mx_tx_lock);
    return MX_NO_RESOURCES;
  }
  
  /* fill in send-specific fields */
  send = &post->ts.send;
  send->length = mx_segment_list_len(segments_list, segments_count);
  
  send->seg_list = mx_new_segment_list(segments_list, segments_count);
  if (send->seg_list == NULL) {
    mx_destroy_post(post);
    pthread_mutex_unlock(&Mx_tx_lock);
    return MX_NO_RESOURCES;
  }
  
  send->seg_cnt = segments_count;
  send->dest = destination;
  send->match_data = 0;
  send->type = MX_SR_TYPE_PUT;

  send->rdma_handle = window_handle;
  send->rdma_offset = offset;

  /* queue the send as pending */
  MX_LIST_INSERT(&pp->send_list, post);
  x = (struct mx_lib_address *)&destination;
  
  MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("posting put %d bytes to 0x%08x:%d\n",
            send->length,
            ntohl(x->ipaddr_n), ntohs(x->ipport_n)));
  
  /*
   * Try to perform the send now
   */
  mx_run_send_queue(pp);
  
  MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("post done\n"));
  
  /* return send handle */
  *request = (mx_request_t) post;
  pthread_mutex_unlock(&Mx_tx_lock);
  pthread_cond_signal(&Mx_send_cond);

  return MX_SUCCESS;

}
#endif
